﻿using Tessa.Extensions.WorkflowExamples.Shared.Roles;
using Tessa.Platform;
using Tessa.Workflow.Actions.Descriptors;
using Unity;
using Unity.Lifetime;

namespace Tessa.Extensions.WorkflowExamples.Shared.Workflow
{
    [Registrator]
    public sealed class Registrator : RegistratorBase
    {
        #region Base Overrides

        public override void RegisterUnity()
        {
            this.UnityContainer
                .RegisterType<IRolesFormationStrategy, RolesFormationStrategy>(new ContainerControlledLifetimeManager());
        }

        /// <inheritdoc/>
        public override void FinalizeRegistration()
        {
            var descriptorRegistry = this.UnityContainer.TryResolve<WorkflowActionDescriptorRegistry>();
            if (descriptorRegistry is not null)
            {
                descriptorRegistry.TryRegisterDescriptor(WfeHelper.WfeLoanSetStateDescriptor);
            }
        }

        #endregion
    }
}
