﻿using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Extensions.WorkflowExamples.Shared.Workflow;
using Unity;
using Unity.Lifetime;

namespace Tessa.Extensions.WorkflowExamples.Server.Cards
{
    [Registrator]
    public sealed class Registrator : RegistratorBase
    {

        public override void RegisterUnity()
        {
            this.UnityContainer
                .RegisterType<WfeLoanApprovalCopyCardNewExtension>(new ContainerControlledLifetimeManager());
        }

        public override void RegisterExtensions(IExtensionContainer extensionContainer)
        {
            extensionContainer
                .RegisterExtension<ICardNewExtension, WfeLoanApprovalCopyCardNewExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform)
                    .WithUnity(this.UnityContainer)
                    .WhenCardTypes(WfeHelper.WfeLoanApprovalTypeID)
                    .WhenAnyNewMethod())
                ;
        }
    }
}
