﻿using System;
using System.Collections.Generic;
using Tessa.Cards;
using Tessa.Extensions.WorkflowExamples.Shared.Workflow;
using Tessa.Platform.Storage;
using Tessa.UI.Cards.Tasks;

namespace Tessa.Extensions.WorkflowExamples.Client.Workflow
{
    public static class WfeUIHelper
    {
        public static Dictionary<int, List<Guid>> HidenTaskInfo = new Dictionary<int, List<Guid>>
            {
                {
                    1, new List<Guid>
                    {
                        WfeCompletionOptions.RequestExpertise,
                        WfeCompletionOptions.ExpertiseConducted
                    }
                },
                {
                    2, new List<Guid>
                    {
                        WfeCompletionOptions.RequestExpertise,
                        WfeCompletionOptions.ExpertiseConducted
                    }
                },
                {
                    3, new List<Guid>
                    {
                        WfeCompletionOptions.RequestExpertise,
                        WfeCompletionOptions.ExpertiseConducted
                    }
                },
                {
                    5, new List<Guid>
                    {
                        WfeCompletionOptions.RequestСonsultation,
                        WfeCompletionOptions.Renouncement,
                        WfeCompletionOptions.СonsultationСonducted
                    }
                },
                {
                    6, new List<Guid>
                    {
                        WfeCompletionOptions.СonsultationСonducted,
                        WfeCompletionOptions.RequestСonsultation
                    }
                },
            };

        public static HashSet<string> HideBlockName = new HashSet<string>
            {
                "RequestExpertiseBlock",
                "TasksEmployeeBlock",
            };
        
        public static string RequestedExpertiseControlName = "RequestedExpertiseControl";
        public static string TasksEmployeeControlName = "TaskTasksEmployeeControl";

        public static string TaskRequestedExpertiseVirtual = "WfeTaskRequestedExpertiseVirtual";
        public static string TaskRequestedDocumentsVirtual = "WfeTaskRequestedDocumentsVirtual";
        public static string TaskTasksEmployee = "WfeTaskTasksEmployee";
        

        public static bool IsHideBlock(string blockName)
        {
            return HideBlockName.Contains(blockName);
        }

        public static bool ExpertiseRowsIsNullOrEmpty(TaskViewModel taskViewModel)
        {
            Card taskCard = taskViewModel.TaskModel.CardTask.TryGetCard();
            StringDictionaryStorage<CardSection> taskSections = taskCard.TryGetSections();

            if (taskSections == null)
            {
                return false;
            }

            taskSections.TryGetValue(TaskRequestedExpertiseVirtual, out CardSection childrenSection);

            if (childrenSection == null)
            {
                return false;
            }
            var childrenRows = childrenSection.TryGetRows();

            if (childrenRows != null)
            {
                return childrenRows.Count == 0;
            }
            return true;
        }

        public static bool TasksEmployeeIsNullOrEmpty(TaskViewModel taskViewModel)
        {
            if (taskViewModel.TaskModel.CardTask != null)
            {
                Card taskCard = taskViewModel.TaskModel.CardTask.TryGetCard();

                StringDictionaryStorage<CardSection> taskSections = taskCard.TryGetSections();

                if (taskSections.TryGetValue(TaskTasksEmployee, out CardSection childrenSection))
                {
                    var childrenRows = childrenSection.TryGetRows();
                    if (childrenRows != null)
                    {
                        return childrenRows.Count == 0;
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
    }
}
