﻿#reference Tessa.Extensions.WorkflowExamples.Shared

#using Tessa.Extensions.WorkflowExamples.Shared.Workflow

// Метод для заполнения параметров в сигнал при передаче задания
public void TaskForSend(CardTask task)
{
    Signal.IsSendSubTask = (bool?)task.Card.DynamicEntries.WfeTasksCommonInfo.IsSendSubtask ?? false;
    Signal.RoleID = task.Card.DynamicEntries.WfeTaskEmployee.EmployeeID;
    Signal.RoleName = task.Card.DynamicEntries.WfeTaskEmployee.EmployeeName;    
}

// Метод окончания экспертизы
public async Task FinishExpertiseAsync(CardTask task)
{
    await WfeWorkflowHelper.FinishExpertiseAsync(
        Context,
        (Guid)Process.ExpertiseID,
        task.TaskAssignedRoles.FirstOrDefault(x => x.Master)?.RoleID ?? this.Session.User.ID,
        (string)task.Card.DynamicEntries.WfeTaskInfo.Comment,
        (Guid?)task.Card.DynamicEntries.WfeTasksCommonInfo.ResultExpertiseRowID,
        (string)task.Card.DynamicEntries.WfeTasksCommonInfo.ResultExpertiseResultName);
}

// Метод для инициализации отправки подзадачи
public async Task StartSubTaskAsync(CardTask task)
{
    var parentTask = (await GetCardObjectAsync()).Tasks.FirstOrDefault(x => x.RowID == Process.TaskID);
    if (Signal.UpdateTaskID != null)
    {
        parentTask.State = CardRowState.Modified;
        var prevTaskID = (Guid)Signal.UpdateTaskID;
        var comment = (string)Signal.UpdateComment ?? String.Empty;
        
        var row = parentTask.Card.Sections["WfeTaskTasksEmployee"].Rows.FirstOrDefault(x => x.Get<Guid>("TaskID") == prevTaskID);
        row.State = CardRowState.Modified;
        row.Fields["CurrentEmployeeID"] = this.Session.User.ID;
        row.Fields["CurrentEmployeeName"] = this.Session.User.Name;
        row.Fields["Comment"] = comment;
        row.Fields["CommentLimit"] = comment.Substring(0, Math.Min(10, comment.Length));
        row.Fields["TaskID"] = task.RowID;
    }
    else
    {
        parentTask.State = CardRowState.Modified;
        var newRow = parentTask.Card.Sections["WfeTaskTasksEmployee"].Rows.Add();
        newRow.State = CardRowState.Inserted;
        newRow.RowID = Guid.NewGuid();
        newRow.Fields["StateID"] = 0;
        newRow.Fields["StateName"] = "В работе";
        newRow.Fields["TaskID"] = task.RowID;
        newRow.Fields["CurrentEmployeeID"] = (Guid)parentTask.Card.DynamicEntries.WfeTaskEmployee.EmployeeID;
        newRow.Fields["CurrentEmployeeName"] = (string)parentTask.Card.DynamicEntries.WfeTaskEmployee.EmployeeName;
    }
}

// Метод обновления подзадачи
public void UpdateSubTask(CardTask task)
{
    Signal.UpdateTaskID = task.RowID;
    Signal.UpdateComment = task.Card.DynamicEntries.WfeTaskInfo.Comment;
}

// Метод окончания подзадачи
public async Task FinishSubTaskAsync(CardTask task)
{
    var parentTask = await Context.GetTaskAsync((Guid)Process.TaskID);
    if (parentTask != null)
    {
        parentTask.State = CardRowState.Modified;
        var comment = (string)task.Card.DynamicEntries.WfeTaskInfo.Comment ?? String.Empty;
    
        var row = parentTask.Card.Sections["WfeTaskTasksEmployee"].Rows.FirstOrDefault(x => x.Get<Guid>("TaskID") == task.RowID);
        if (row == null)
        {
            return;
        }
        row.State = CardRowState.Modified;
        row.Fields["Comment"] = comment;
        row.Fields["CommentLimit"] = comment.Substring(0, Math.Min(10, comment.Length));
        row.Fields["StateID"] = 1;
        row.Fields["StateName"] = "Завершено";
        row.Fields["ResultRowID"] = (Guid?)task.Card.DynamicEntries.WfeTasksCommonInfo.ResultExpertiseRowID;
        row.Fields["ResultResultName"] = (string)task.Card.DynamicEntries.WfeTasksCommonInfo.ResultExpertiseResultName;
    }
}

// Метод для формирования описания задания из комментария предыдущего задания
public async Task FillDigestWithCommentAsync(CardTask task)
{
    var parentTaskID = this.SignalObject.As<WorkflowEngineTaskSignal>().TaskIDs[0];
    var parentTask = await Context.GetTaskAsync(parentTaskID);
    
    task.Digest += "\n\n" + Session.User.Name + ": " + 
    (parentTask.Card.Sections.GetOrAdd("WfeTaskInfo").RawFields.TryGet<string>("Comment") ?? parentTask.Card.Sections.GetOrAdd("WfeTasksCommonInfo").RawFields.TryGet<string>("Comment") ?? string.Empty);
}

// Метод старта отправки запроса комментария
public async Task WriteQuestionAsync(CardTask task)
{
    var parentTaskID = this.SignalObject.As<WorkflowEngineTaskSignal>().TaskIDs[0];
    var parentTask = await Context.GetTaskAsync(parentTaskID);
    
    task.ParentRowID = parentTaskID;
    task.HistoryItemParentRowID = parentTaskID;
    task.TaskAssignedRoles.RemoveAll(x => x.TaskRoleID == CardFunctionRoles.PerformerID);
    task.AddPerformer(
        (Guid) parentTask.Card.DynamicEntries.WfeTasksCommonInfo.RoleID,
        (string) parentTask.Card.DynamicEntries.WfeTasksCommonInfo.RoleName);
    Process.Questions = (int)Process.Questions + 1;
}

// Метод завершения отправки запроса комментария
public void WriteAnswer(CardTask task)
{
    Process.Questions = (int)Process.Questions - 1; 
}