﻿CREATE FUNCTION [AeGetOrganization]
(
	@RoleID uniqueidentifier
)
RETURNS TABLE 
AS
RETURN
(
	WITH [DepartmentsCTE] ([ID], [ParentID], [HierarchyLevel]) AS 
	(
		SELECT 
			[rc].[ID], [rc].[ParentID], 0 AS [HierarchyLevel]
		FROM [Roles] AS [rc] WITH (NOLOCK)
		WHERE 
			[rc].[TypeID] = 2 
			AND [rc].[ID] = @RoleID
		UNION ALL
		SELECT 
			[rp].[ID], [rp].[ParentID], [dc].[HierarchyLevel] + 1 AS [HierarchyLevel]
		FROM [Roles] AS [rp] WITH (NOLOCK)
		INNER JOIN [DepartmentsCTE] AS [dc] 
			ON [dc].[ParentID] = [rp].[ID]
		WHERE [rp].[TypeID] = 2
	)
	SELECT TOP (1) 
		[aco].[ID], [aco].[Name]
	FROM [DepartmentsCTE] AS [dc]
	INNER JOIN [Roles] AS [r] WITH (NOLOCK) 
		ON [r].[ID] = [dc].[ID]
	INNER JOIN [AclDepartmentRoles] AS [acd] WITH (NOLOCK) 
		ON [acd].[ID] = [r].[ID]
	INNER JOIN [AclOrganization] as [aco] WITH(NOLOCK)
		ON [aco].[DepartmentID] = [r].[ID]
	WHERE [acd].[DepartmentTypeID] = 0
	ORDER BY [dc].[HierarchyLevel] ASC
)